/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.simplexml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Stack;
import net.cnri.simplexml.XTag;
import net.cnri.simplexml.XUtil;

public class XParser {
    private static boolean debug = false;
    private final boolean stripNewLine = true;
    private final boolean strictMode = false;

    private void parseTagAttributes(PushbackReader reader, ParseTag tag) throws IOException {
        HashMap<String, String> attributes = tag.attributes;
        String attName = null;
        String attVal = null;
        block7: while (true) {
            int ci;
            if ((ci = reader.read()) < 0) {
                throw new IOException("Unexpected end of input reading attributes");
            }
            char ch = (char)ci;
            switch (ch) {
                case '>': {
                    if (attName != null) {
                        attributes.put(attName, attVal == null ? "NULL" : attVal);
                    }
                    return;
                }
                case '=': {
                    if (attName == null) {
                        attName = "";
                    }
                    attVal = this.readToken(reader);
                    continue block7;
                }
                case '/': {
                    if (attName != null) {
                        attributes.put(attName, attVal == null ? "NULL" : attVal);
                        attName = null;
                        attVal = null;
                    }
                    tag.isEndTag = true;
                    continue block7;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block7;
                }
                case '\"': 
                case '\'': {
                    if (attName != null) {
                        if (attributes == null) {
                            attributes = new HashMap<String, String>();
                        }
                        attributes.put(attName, attVal == null ? "NULL" : attVal);
                        attVal = null;
                    }
                    attName = this.readRestOfString(ch, reader);
                    continue block7;
                }
            }
            if (attName != null) {
                attributes.put(attName, attVal == null ? "NULL" : attVal);
                attName = null;
                attVal = null;
            }
            reader.unread(ch);
            attName = this.readToken(reader);
        }
    }

    private String readToken(PushbackReader reader) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ci;
            if ((ci = reader.read()) < 0) {
                throw new IOException("Unexpected end of input reading token: " + sb);
            }
            char ch = (char)ci;
            if (Character.isWhitespace(ch)) {
                if (sb.length() <= 0) continue;
                return XUtil.decodeString(sb.toString());
            }
            if (ch == '\"' || ch == '\'') {
                if (sb.length() <= 0) {
                    return this.readRestOfString(ch, reader);
                }
                reader.unread(ch);
                return XUtil.decodeString(sb.toString());
            }
            if (ch == '=') {
                if (sb.length() <= 0) {
                    return String.valueOf(ch);
                }
                reader.unread(ch);
                return XUtil.decodeString(sb.toString());
            }
            if (ch == '>' || ch == '<') {
                if (sb.length() <= 0) {
                    return String.valueOf(ch);
                }
                reader.unread(ch);
                return XUtil.decodeString(sb.toString());
            }
            sb.append(ch);
        }
    }

    private String readRestOfString(char strBeginChar, PushbackReader reader) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ci;
            if ((ci = reader.read()) < 0) {
                throw new IOException("Unexpected end of input reading string: " + sb);
            }
            char ch = (char)ci;
            if (ch == strBeginChar) {
                return XUtil.decodeString(sb.toString());
            }
            sb.append(ch);
        }
    }

    private boolean readTagToken(PushbackReader reader, ParseTag tag) throws IOException {
        int ci;
        tag.resetValues();
        while ((ci = reader.read()) != 60) {
            if (ci >= 0) continue;
            return false;
        }
        while ((ci = reader.read()) != 62) {
            if (ci < 0) {
                throw new IOException("Unexpected end of input reading tag");
            }
            char ch = (char)ci;
            if (ch == '/') {
                if (tag.name.length() <= 0) {
                    tag.isAggregateEnd = true;
                    continue;
                }
                tag.isEndTag = true;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                if (tag.name.length() <= 0) continue;
                if (tag.name.toString().startsWith("!--")) {
                    tag.name.setLength(0);
                    tag.name.append("*********");
                    tag.isComment = true;
                    String comment = "";
                    while (!comment.toString().endsWith("-->")) {
                        ci = reader.read();
                        if (ci < 0) {
                            throw new IOException("Unexpected end of input reading comment tag");
                        }
                        comment = comment + (char)ci;
                    }
                    return true;
                }
                this.parseTagAttributes(reader, tag);
                break;
            }
            tag.name.append(ch);
        }
        return true;
    }

    private String readTagValue(PushbackReader reader) throws IOException {
        int ci;
        StringBuffer sb = new StringBuffer();
        while ((ci = reader.read()) != 60) {
            if (ci < 0) {
                throw new IOException("Unexpected end of input reading tag value");
            }
            sb.append((char)ci);
        }
        reader.unread(60);
        String s = sb.toString();
        if (s.endsWith("\r\n")) {
            return XUtil.decodeString(s.substring(0, s.length() - 2));
        }
        if (s.endsWith("\n")) {
            return XUtil.decodeString(s.substring(0, s.length() - 1));
        }
        return XUtil.decodeString(s);
    }

    private XTag parseNonRecursive(PushbackReader reader) throws IOException {
        Stack parseStack = new Stack();
        Stack<XTag> aggregateStack = new Stack<XTag>();
        ParseTag tag = new ParseTag();
        while (true) {
            XTag xtag;
            tag.resetValues();
            do {
                if (this.readTagToken(reader, tag)) continue;
                if (parseStack.size() <= 0) {
                    return null;
                }
                Stack tmpStack = new Stack();
                while (parseStack.size() > 1) {
                    tmpStack.push(parseStack.pop());
                }
                XTag xtag2 = (XTag)parseStack.pop();
                while (tmpStack.size() > 0) {
                    xtag2.addSubTag((XTag)tmpStack.pop());
                }
                return xtag2;
            } while (tag.isComment);
            String tagname = tag.name.toString().trim();
            if (debug) {
                System.err.println("read tag: " + tag);
            }
            if (tag.isAggregateEnd) {
                aggregateStack.clear();
                XTag subtag = null;
                while (true) {
                    if (parseStack.size() <= 0) {
                        while (aggregateStack.size() > 0) {
                            parseStack.push(aggregateStack.pop());
                        }
                        subtag = null;
                        break;
                    }
                    subtag = (XTag)parseStack.pop();
                    if (subtag.getName().equals(tagname) && subtag.getSubTagCount() <= 0) break;
                    aggregateStack.push(subtag);
                }
                if (subtag == null) continue;
                while (aggregateStack.size() > 0) {
                    subtag.addSubTag((XTag)aggregateStack.pop());
                }
                if (subtag.getSubTagCount() > 0) {
                    subtag.setValue(null);
                }
                if (parseStack.size() <= 0) {
                    return subtag;
                }
                parseStack.push(subtag);
                continue;
            }
            if (tag.isEndTag) {
                xtag = new XTag(tagname);
                xtag.setAttributes(tag.attributes);
                parseStack.push(xtag);
                continue;
            }
            xtag = new XTag(tagname, this.readTagValue(reader));
            xtag.setAttributes(tag.attributes);
            parseStack.push(xtag);
        }
    }

    public XTag parse(Reader reader, boolean strict) throws Exception {
        return this.parseNonRecursive(new PushbackReader(reader));
    }

    public static void main(String[] argv) throws Exception {
        debug = true;
        XParser parser = new XParser();
        XTag xTag = parser.parse(new InputStreamReader(System.in, "UTF8"), false);
        System.err.println("parsed: " + xTag);
    }

    private class ParseTag {
        StringBuffer name = new StringBuffer();
        HashMap attributes = new HashMap();
        boolean isComment;
        boolean isEndTag;
        boolean isAggregateEnd;

        ParseTag() {
            this.resetValues();
        }

        void resetValues() {
            this.name.setLength(0);
            this.attributes.clear();
            this.isComment = false;
            this.isEndTag = false;
            this.isAggregateEnd = false;
        }

        public String toString() {
            return this.name == null ? "null" : this.name.toString();
        }
    }
}

