/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.batch.operations;

import java.util.List;
import net.handle.apps.batch.BatchUtil;
import net.handle.apps.batch.HandleRecordOperationInterface;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class ReplaceHsNamespaceOperation
implements HandleRecordOperationInterface {
    private final byte[] bytes;

    public ReplaceHsNamespaceOperation(String replacementNamespaceString) {
        this.bytes = Util.encodeString(replacementNamespaceString);
    }

    @Override
    public void process(String handle, HandleValue[] values, HandleResolver resolver, AuthenticationInfo authInfo, SiteInfo site) throws HandleException {
        List<HandleValue> existingNamespaceValues = BatchUtil.getValuesOfType(values, "HS_NAMESPACE");
        if (existingNamespaceValues.size() != 1) {
            throw new HandleException(1, "Handle does not have exactly one HS_NAMESPACE");
        }
        HandleValue existingNamespaceValue = existingNamespaceValues.get(0);
        existingNamespaceValue.setData(this.bytes);
        AbstractResponse response = BatchUtil.modifyHandleValue(handle, existingNamespaceValue, resolver, authInfo, site);
        BatchUtil.throwIfNotSuccess(response);
    }
}

