/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.io.IOException;
import java.io.OutputStream;
import java.net.IDN;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.handle.dnslib.ParseException;
import net.handle.dnslib.ResourceRecord;
import net.handle.hdllib.Util;

public class DomainName {
    public static final String HEX_ENCODING_PREFIX = "hx--";
    public static final DomainName ROOT = new DomainName(new byte[0][]);
    private final byte[][] labels;
    private byte[][] _casefoldedLabels = null;
    private DomainName _parent;
    private static final byte[] ASTERISK_LABEL = new byte[]{42};
    private Integer _hashcode = null;

    public DomainName(byte[][] labels) {
        this.labels = labels;
    }

    public byte[][] getLabels() {
        if (this.labels == null) {
            return null;
        }
        if (this.labels.length == 0) {
            return DomainName.ROOT.labels;
        }
        byte[][] res = new byte[this.labels.length][];
        for (int i = 0; i < this.labels.length; ++i) {
            res[i] = new byte[this.labels[i].length];
            System.arraycopy(this.labels[i], 0, res[i], 0, this.labels[i].length);
        }
        return res;
    }

    public String toString() {
        if (this.labels.length == 0) {
            return ".";
        }
        StringBuilder sb = new StringBuilder();
        byte[][] byArray = this.labels;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] label;
            for (int n2 : label = byArray[i]) {
                if (n2 <= 32 || n2 >= 127) {
                    sb.append('\\');
                    sb.append(n2 < 0 ? n2 + 128 : n2);
                    continue;
                }
                if (n2 == 34 || n2 == 35 || n2 == 39 || n2 == 40 || n2 == 41 || n2 == 46 || n2 == 59 || n2 == 64 || n2 == 92) {
                    sb.append('\\');
                }
                sb.append((char)n2);
            }
            sb.append('.');
        }
        return sb.toString();
    }

    public static DomainName ofString(String s) throws ParseException {
        if (s == null) {
            throw new NullPointerException();
        }
        if ("".equals(s) || ".".equals(s)) {
            return ROOT;
        }
        boolean potentialIDNA = true;
        ArrayList<String> ss = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '.') {
                ss.add(s.substring(start, i));
                start = i + 1;
                continue;
            }
            if (s.charAt(i) != '\\') continue;
            if (++i >= s.length()) {
                throw new ParseException("Domain name " + s + " ends with slash");
            }
            if (s.charAt(i) < '0' || s.charAt(i) > '9') continue;
            potentialIDNA = false;
        }
        if (start < s.length()) {
            ss.add(s.substring(start));
        }
        byte[][] newLabels = new byte[ss.size()][];
        for (int j = 0; j < ss.size(); ++j) {
            newLabels[j] = ResourceRecord.parseMasterFileDataString((String)ss.get(j));
            try {
                if (potentialIDNA) {
                    newLabels[j] = Util.encodeString(IDN.toASCII(Util.decodeString(newLabels[j]), 1));
                }
            }
            catch (Exception e) {
                throw new ParseException(e.toString());
            }
            if (newLabels[j].length <= 63) continue;
            throw new ParseException("label too long");
        }
        return new DomainName(newLabels);
    }

    public static final boolean isHexByte(byte ch1, byte ch2) {
        return (ch1 >= 48 && ch1 <= 57 || ch1 >= 97 && ch1 <= 122 || ch1 >= 65 && ch1 <= 90) && (ch2 >= 48 && ch2 <= 57 || ch2 >= 97 && ch2 <= 122 || ch2 >= 65 && ch2 <= 90);
    }

    public static final byte decodeHexByte(byte ch1, byte ch2) {
        char newch1 = (char)(ch1 >= 48 && ch1 <= 57 ? ch1 - 48 : (ch1 >= 97 && ch1 <= 122 ? ch1 - 97 + 10 : ch1 - 65 + 10));
        char newch2 = (char)(ch2 >= 48 && ch2 <= 57 ? ch2 - 48 : (ch2 >= 97 && ch2 <= 122 ? ch2 - 97 + 10 : ch2 - 65 + 10));
        return (byte)(newch1 << 4 | newch2);
    }

    public byte[] toHandle(String handlePrefix, int lengthOfAssumedDomain) throws ParseException {
        if (this.labels.length < lengthOfAssumedDomain) {
            throw new IllegalArgumentException();
        }
        if (this.labels.length == lengthOfAssumedDomain) {
            return Util.encodeString(handlePrefix);
        }
        StringBuilder sb = new StringBuilder(handlePrefix);
        for (int i = this.labels.length - lengthOfAssumedDomain - 1; i >= 0; --i) {
            String converted;
            sb.append('/');
            String labelString = Util.decodeString(this.labels[i]);
            try {
                converted = IDN.toUnicode(labelString, 1);
            }
            catch (Exception e) {
                throw new ParseException(e.toString());
            }
            if (converted.length() > 4 && HEX_ENCODING_PREFIX.equals(converted.substring(0, 4))) {
                byte[] bytes = Util.encodeString(converted.toString());
                byte[] newBytes = new byte[bytes.length - 4];
                int size = 0;
                for (int j = 4; j < bytes.length; ++j) {
                    if (bytes[j] != 45) {
                        newBytes[size] = bytes[j];
                    } else {
                        if (j + 2 >= bytes.length || !DomainName.isHexByte(bytes[j + 1], bytes[j + 2])) {
                            throw new ParseException("Error in hx-- parsing: " + converted);
                        }
                        newBytes[size] = DomainName.decodeHexByte(bytes[j + 1], bytes[j + 2]);
                        j += 2;
                    }
                    ++size;
                }
                byte[] newLabel = new byte[size];
                System.arraycopy(newBytes, 0, newLabel, 0, size);
                sb.append(Util.decodeString(newLabel));
                continue;
            }
            sb.append(converted);
        }
        return Util.encodeString(sb.toString());
    }

    private byte[][] getCasefoldedLabels() {
        if (this._casefoldedLabels != null) {
            return this._casefoldedLabels;
        }
        this._casefoldedLabels = new byte[this.labels.length][];
        for (int i = 0; i < this.labels.length; ++i) {
            this._casefoldedLabels[i] = new byte[this.labels[i].length];
            for (int j = 0; j < this.labels[i].length; ++j) {
                this._casefoldedLabels[i][j] = this.labels[i][j] >= 65 && this.labels[i][j] <= 90 ? (byte)(this.labels[i][j] - 65 + 97) : this.labels[i][j];
            }
        }
        return this._casefoldedLabels;
    }

    public DomainName parent() {
        if (this.labels.length == 0) {
            return null;
        }
        if (this.labels.length == 1) {
            return ROOT;
        }
        if (this._parent != null) {
            return this._parent;
        }
        byte[][] res = new byte[this.labels.length - 1][];
        System.arraycopy(this.labels, 1, res, 0, this.labels.length - 1);
        DomainName dn = new DomainName(res);
        if (this._casefoldedLabels != null) {
            dn._casefoldedLabels = new byte[this.labels.length - 1][];
            System.arraycopy(this._casefoldedLabels, 1, dn._casefoldedLabels, 0, this.labels.length - 1);
        }
        this._parent = dn;
        return dn;
    }

    public DomainName ancestorChildOf(DomainName name) {
        if (this.labels.length + 1 > name.labels.length) {
            return null;
        }
        if (this.labels.length + 1 == name.labels.length) {
            return name;
        }
        byte[][] newlabels = new byte[this.labels.length + 1][];
        System.arraycopy(this.labels, 0, newlabels, 1, this.labels.length);
        newlabels[0] = name.labels[name.labels.length - this.labels.length - 1];
        return new DomainName(newlabels);
    }

    public boolean descendsFrom(DomainName ancestor) {
        if (this.labels.length < ancestor.labels.length) {
            return false;
        }
        for (int i = 0; i < ancestor.labels.length; ++i) {
            if (Util.equals(this.getCasefoldedLabels()[i + this.labels.length - ancestor.labels.length], ancestor.getCasefoldedLabels()[i])) continue;
            return false;
        }
        return true;
    }

    public DomainName asteriskLabelSibling() {
        if (this.labels.length == 0) {
            return null;
        }
        byte[][] newlabels = new byte[this.labels.length][];
        System.arraycopy(this.labels, 1, newlabels, 1, this.labels.length - 1);
        newlabels[0] = ASTERISK_LABEL;
        return new DomainName(newlabels);
    }

    public int length() {
        return this.labels.length;
    }

    public static DomainName parseWire(byte[] wire, int[] offsetArr) throws ParseException {
        ArrayList<byte[]> labels = new ArrayList<byte[]>();
        offsetArr[0] = DomainName.parseWire(wire, offsetArr[0], labels, 0, false);
        if (labels.size() == 0) {
            return ROOT;
        }
        return new DomainName((byte[][])labels.toArray((T[])new byte[labels.size()][]));
    }

    private static int parseWire(byte[] wire, int offset, ArrayList<byte[]> labels, int totallen, boolean lastWasPointer) throws ParseException {
        if (totallen > 255) {
            throw new ParseException("DomainName too long; perhaps a pointer loop?");
        }
        try {
            while (true) {
                byte len;
                if ((wire[offset] & 0xC0) != 0) {
                    if ((wire[offset] & 0xC0) != 192) {
                        throw new ParseException("Unexpected label type");
                    }
                    int pointer = (wire[offset++] & 0x3F) << 8 | wire[offset++] & 0xFF;
                    if (lastWasPointer && pointer >= offset - 2) {
                        throw new ParseException("Possible pointer loop?");
                    }
                    DomainName.parseWire(wire, pointer, labels, totallen, true);
                    return offset;
                }
                if ((len = wire[offset++]) == 0) break;
                byte[] newlabel = new byte[len];
                System.arraycopy(wire, offset, newlabel, 0, len);
                labels.add(newlabel);
                offset += len;
                totallen += len + 1;
                lastWasPointer = false;
            }
            return offset;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException("IndexOutOfBoundsException parsing domain name");
        }
    }

    public int appendToWireWithCompression(OutputStream wire, int offset, Map<DomainName, Integer> compressionTable) throws IOException {
        return this.appendToWireWithCompression(wire, offset, compressionTable, true);
    }

    public int appendToWireWithCompression(OutputStream wire, int offset, Map<DomainName, Integer> compressionTable, boolean compress) throws IOException {
        DomainName dn = this;
        while (dn.labels.length > 0) {
            int pointer;
            Integer pointerObj = null;
            if (compress && compressionTable != null) {
                pointerObj = compressionTable.get(dn);
            }
            int n = pointer = pointerObj != null ? pointerObj : -1;
            if (pointer < 0 || pointer >= 16384) {
                if (compressionTable != null && offset < 16384) {
                    compressionTable.put(dn, offset);
                }
                byte[] label = dn.labels[0];
                wire.write(label.length);
                ++offset;
                wire.write(label);
                offset += label.length;
                dn = dn.parent();
                continue;
            }
            wire.write(((pointer |= 0xC000) & 0xFF00) >>> 8);
            wire.write(pointer & 0xFF);
            return offset += 2;
        }
        wire.write(0);
        return ++offset;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DomainName)) {
            return false;
        }
        DomainName that = (DomainName)obj;
        if (this.labels.length != that.labels.length) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.getCasefoldedLabels(), (Object[])that.getCasefoldedLabels());
    }

    public int hashCode() {
        if (this._hashcode == null) {
            this._hashcode = Arrays.deepHashCode((Object[])this.getCasefoldedLabels());
        }
        return this._hashcode;
    }
}

