/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import net.handle.dnslib.DomainName;
import net.handle.dnslib.MultiRRSet;
import net.handle.dnslib.ParseException;
import net.handle.dnslib.Question;
import net.handle.dnslib.RRSet;
import net.handle.dnslib.ResourceRecord;

public class Message
implements Cloneable {
    public static final byte RC_OK = 0;
    public static final byte RC_FORMAT_ERROR = 1;
    public static final byte RC_SERVER_ERROR = 2;
    public static final byte RC_NAME_ERROR = 3;
    public static final byte RC_NOT_IMPLEMENTED = 4;
    public static final byte RC_REFUSED = 5;
    public static final int META_TYPE_OPT = 41;
    public static final int QTYPE_IXFR = 251;
    public static final int QTYPE_AXFR = 252;
    public static final int QTYPE_MAILB = 253;
    public static final int QTYPE_MAILA = 254;
    public static final int QTYPE_ANY = 255;
    public int id;
    private boolean isQueryResponse;
    private byte opcode;
    boolean authAnswer;
    boolean truncated;
    public boolean recursionDesired;
    private boolean recursionAvailable;
    private byte responseCode;
    private Question[] questions;
    MultiRRSet answer = new MultiRRSet();
    MultiRRSet authority = new MultiRRSet();
    MultiRRSet additional = new MultiRRSet();
    ResourceRecord ednsOptRecord;
    protected Set<Question> additionalFromAnswerOrReferral;
    private static final Random RANDOM = new Random();
    public static final ResourceRecord SMALL_EDNS;
    public static final ResourceRecord LARGE_EDNS;
    public static final ResourceRecord SMALL_EDNS_BADVERS;
    public static final ResourceRecord LARGE_EDNS_BADVERS;
    private int _ttl = Integer.MAX_VALUE;
    private byte[] _cachedDatagram;
    private static final char[] HEX_VALUES;

    public Message() {
    }

    public static Message copy(Message message) {
        try {
            return (Message)message.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Message(Question q, boolean recursionDesired, boolean useEDNS) {
        this.id = RANDOM.nextInt(65536);
        this.questions = new Question[]{q};
        if (useEDNS) {
            this.ednsOptRecord = LARGE_EDNS;
        }
        this.recursionDesired = recursionDesired;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    public Question getQuestion() {
        if (this.questions == null || this.questions.length != 1) {
            return null;
        }
        return this.questions[0];
    }

    public String getQuestionNameAsString() {
        if (this.questions != null && this.questions.length >= 1) {
            return this.questions[0].getName().toString();
        }
        return null;
    }

    public Question getQuestionAfterCNAME() {
        boolean answered;
        boolean changed;
        Question question = this.getQuestion();
        if (question == null) {
            return null;
        }
        Question nextQuestion = question;
        block0: do {
            changed = false;
            answered = false;
            question = nextQuestion;
            for (RRSet rrs : this.answer.values()) {
                Question key = rrs.getKey();
                if (key.isAnswerFor(question)) {
                    answered = true;
                    continue block0;
                }
                if (key.getKlass() != question.getKlass() || key.getType() != 5 || !key.getName().equals(question.getName())) continue;
                for (ResourceRecord rr : rrs) {
                    changed = true;
                    nextQuestion = new Question(rr.nameFromData(), question.getType(), question.getKlass());
                }
            }
        } while (changed && !answered);
        return question;
    }

    public boolean getRecursionDesired() {
        return this.recursionDesired;
    }

    public int getTTL() {
        int ttl;
        int res = this._ttl;
        if (res < Integer.MAX_VALUE) {
            return res;
        }
        int ncache = 0;
        Question question = this.getQuestionAfterCNAME();
        boolean soa = false;
        boolean ns = false;
        boolean nodata = true;
        for (RRSet rrs : this.answer.values()) {
            ttl = rrs.getTTL();
            if (ttl < res) {
                res = ttl;
            }
            if (!nodata || !rrs.getKey().isAnswerFor(question)) continue;
            nodata = false;
        }
        for (RRSet rrs : this.authority.values()) {
            ttl = rrs.getTTL();
            if (ttl < res) {
                res = ttl;
            }
            if (rrs.getType() == 6) {
                soa = true;
                for (ResourceRecord rr : rrs) {
                    ncache = rr.minimumFromSOAData();
                }
            }
            if (rrs.getType() != 2) continue;
            ns = true;
        }
        for (RRSet rrs : this.additional.values()) {
            ttl = rrs.getTTL();
            if (ttl >= res) continue;
            res = ttl;
        }
        int rc = this.getExtendedResponseCode();
        if ((rc == 0 && nodata && (soa || !ns) || rc == 3) && ncache < res) {
            res = ncache;
        }
        this._ttl = res;
        return res;
    }

    public int parseWire(byte[] wire) throws ParseException {
        int i;
        int flags;
        int offset = 0;
        if (wire.length < 12) {
            throw new ParseException("not enough room of for DNS message header");
        }
        this.id = (wire[offset++] & 0xFF) << 8 | wire[offset++] & 0xFF;
        this.isQueryResponse = ((flags = (wire[offset++] & 0xFF) << 8 | wire[offset++] & 0xFF) & 0x8000) != 0;
        this.opcode = (byte)((flags & 0x7800) >> 11);
        this.authAnswer = (flags & 0x400) != 0;
        this.truncated = (flags & 0x200) != 0;
        this.recursionDesired = (flags & 0x100) != 0;
        this.recursionAvailable = (flags & 0x80) != 0;
        this.responseCode = (byte)(flags & 0xF);
        int qcount = (wire[offset++] & 0xFF) << 8 | wire[offset++] & 0xFF;
        int anscount = (wire[offset++] & 0xFF) << 8 | wire[offset++] & 0xFF;
        int authcount = (wire[offset++] & 0xFF) << 8 | wire[offset++] & 0xFF;
        int addcount = (wire[offset++] & 0xFF) << 8 | wire[offset++] & 0xFF;
        int[] offsetArr = new int[]{offset};
        this.questions = new Question[qcount];
        for (i = 0; i < qcount; ++i) {
            this.questions[i] = Question.parseWire(wire, offsetArr);
        }
        this.answer.clear();
        for (i = 0; i < anscount; ++i) {
            this.answer.add(ResourceRecord.parseWire(wire, offsetArr));
        }
        this.authority.clear();
        for (i = 0; i < authcount; ++i) {
            this.authority.add(ResourceRecord.parseWire(wire, offsetArr));
        }
        this.additional.clear();
        this.ednsOptRecord = null;
        for (i = 0; i < addcount; ++i) {
            ResourceRecord rr = ResourceRecord.parseWire(wire, offsetArr);
            if (rr.getType() == 41 && this.ednsOptRecord == null) {
                this.ednsOptRecord = rr;
                continue;
            }
            this.additional.add(rr);
        }
        return offsetArr[0];
    }

    public int getUDPPayloadSize() {
        if (this.ednsOptRecord == null) {
            return 512;
        }
        return this.ednsOptRecord.getKlass();
    }

    public int getEDNSVersion() {
        if (this.ednsOptRecord == null) {
            return -1;
        }
        return (this.ednsOptRecord.getTTL() & 0xFF0000) >> 16;
    }

    public int getExtendedResponseCode() {
        if (this.ednsOptRecord == null) {
            return this.responseCode;
        }
        return (this.ednsOptRecord.getTTL() & 0xFF000000) >>> 20 | this.responseCode;
    }

    public void setResponseCode(byte responseCode) {
        ResourceRecord newEDNSOptRecord;
        this.responseCode = responseCode;
        if (this.ednsOptRecord == null || (this.ednsOptRecord.getTTL() & 0xFF000000) == 0) {
            return;
        }
        int ttl = this.ednsOptRecord.getTTL() & 0xFFFFFF;
        this.ednsOptRecord = newEDNSOptRecord = new ResourceRecord(this.ednsOptRecord.getOwner(), ttl, this.ednsOptRecord);
    }

    public static Message initialResponse(Message query, boolean recursionAvailable, boolean largeEDNS) {
        if (query.isQueryResponse) {
            return null;
        }
        Message msg = new Message();
        msg.id = query.id;
        msg.isQueryResponse = true;
        msg.opcode = query.opcode;
        msg.recursionDesired = query.recursionDesired;
        msg.recursionAvailable = recursionAvailable;
        if (query.truncated) {
            msg.responseCode = 1;
        } else if (query.opcode != 0) {
            msg.responseCode = (byte)4;
        } else if (query.questions.length != 1) {
            msg.responseCode = 1;
        } else if (query.questions[0].getType() == 41) {
            msg.responseCode = 1;
        } else if (query.questions[0].getType() == 252 || query.questions[0].getType() == 251) {
            msg.responseCode = (byte)5;
        } else if (query.questions[0].getKlass() != 1) {
            msg.responseCode = (byte)5;
        } else if (query.ednsOptRecord != null) {
            if (query.ednsOptRecord.getOwner() != DomainName.ROOT) {
                msg.responseCode = 1;
            } else {
                for (Question q : query.additional.keySet()) {
                    if (q.getType() != 41) continue;
                    msg.responseCode = 1;
                    break;
                }
            }
        }
        msg.questions = query.questions;
        int queryEDNSVersion = query.getEDNSVersion();
        if (queryEDNSVersion > 0) {
            msg.ednsOptRecord = largeEDNS ? LARGE_EDNS_BADVERS : SMALL_EDNS_BADVERS;
        } else if (queryEDNSVersion == 0) {
            msg.ednsOptRecord = largeEDNS ? LARGE_EDNS : SMALL_EDNS;
        }
        return msg;
    }

    public int appendToWire(OutputStream wire) throws IOException {
        return this.appendToWire(wire, new PartialResults(), 65535, false);
    }

    private byte[] getCachedDatagram(int udpPayloadSize) {
        if (this._cachedDatagram == null || this._cachedDatagram.length > udpPayloadSize || this._cachedDatagram.length < 3) {
            return null;
        }
        byte[] res = (byte[])this._cachedDatagram.clone();
        res[0] = (byte)(this.id >> 8 & 0xFF);
        res[1] = (byte)(this.id & 0xFF);
        int flags = res[2] & 0xFF;
        if (this.recursionDesired) {
            flags |= 1;
        }
        if (!this.recursionDesired) {
            flags &= 0xFFFFFFFE;
        }
        res[2] = (byte)flags;
        return res;
    }

    private void setCachedDatagram(byte[] buf) {
        this._cachedDatagram = buf;
    }

    public byte[] getDatagram(int udpPayloadSize) throws IOException {
        byte[] cachedDatagram = this.getCachedDatagram(udpPayloadSize);
        if (cachedDatagram != null) {
            return cachedDatagram;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PartialResults partial = new PartialResults();
        int offset = this.appendToWire(out, partial, udpPayloadSize, false);
        if (partial.lastGoodOffset == offset) {
            byte[] res = out.toByteArray();
            this.setCachedDatagram(res);
            return res;
        }
        int anscount = 0;
        for (RRSet rRSet : this.answer.values()) {
            anscount += rRSet.size();
        }
        if (partial.anscount < anscount) {
            return this.truncationResponse();
        }
        int authcount = 0;
        for (RRSet rrs : this.authority.values()) {
            authcount += rrs.size();
        }
        if (partial.authcount < authcount || this.ednsOptRecord != null && partial.addcount == 0) {
            if (this.authorityIsOmittable()) {
                authcount = 0;
                out.reset();
                partial = new PartialResults();
                offset = this.appendToWire(out, partial, udpPayloadSize, true);
                if (partial.lastGoodOffset == offset) {
                    return out.toByteArray();
                }
            }
            if (partial.authcount < authcount || this.ednsOptRecord != null && partial.addcount == 0) {
                return this.truncationResponse();
            }
        }
        byte[] byArray = new byte[partial.lastGoodOffset];
        System.arraycopy(out.toByteArray(), 0, byArray, 0, partial.lastGoodOffset);
        byArray[10] = (byte)(partial.addcount >> 8 & 0xFF);
        byArray[11] = (byte)(partial.addcount & 0xFF);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private int appendToWire(OutputStream wire, PartialResults partial, int udpPayloadSize, boolean omitAuthority) throws IOException {
        void var10_16;
        int offset = 0;
        wire.write(this.id >> 8 & 0xFF);
        wire.write(this.id & 0xFF);
        int flags = 0;
        if (this.isQueryResponse) {
            flags |= 0x80;
        }
        flags |= (this.opcode & 0xF) << 3;
        if (this.authAnswer) {
            flags |= 4;
        }
        if (this.truncated) {
            flags |= 2;
        }
        if (this.recursionDesired) {
            flags |= 1;
        }
        wire.write(flags);
        flags = 0;
        if (this.recursionAvailable) {
            flags |= 0x80;
        }
        wire.write(flags |= this.responseCode & 0xF);
        int qcount = this.questions.length;
        int anscount = 0;
        for (RRSet rRSet : this.answer.values()) {
            anscount += rRSet.size();
        }
        int authcount = 0;
        if (!omitAuthority) {
            for (RRSet rrs : this.authority.values()) {
                authcount += rrs.size();
            }
        }
        if (!omitAuthority || this.additionalFromAnswerOrReferral == null) {
            Collection<RRSet> collection = this.additional.values();
        } else {
            ArrayList<RRSet> list = new ArrayList<RRSet>();
            for (Question q : this.additionalFromAnswerOrReferral) {
                RRSet rrs = this.additional.get(q);
                if (rrs == null) continue;
                list.add(rrs);
            }
            ArrayList<RRSet> arrayList = list;
        }
        int addcount = 0;
        for (RRSet rrs : var10_16) {
            addcount += rrs.size();
        }
        if (this.ednsOptRecord != null) {
            ++addcount;
        }
        wire.write(qcount >> 8 & 0xFF);
        wire.write(qcount & 0xFF);
        wire.write(anscount >> 8 & 0xFF);
        wire.write(anscount & 0xFF);
        wire.write(authcount >> 8 & 0xFF);
        wire.write(authcount & 0xFF);
        wire.write(addcount >> 8 & 0xFF);
        wire.write(addcount & 0xFF);
        offset += 12;
        HashMap<DomainName, Integer> compressionTable = new HashMap<DomainName, Integer>();
        for (Question q : this.questions) {
            offset = q.appendToWireWithCompression(wire, offset, compressionTable);
        }
        partial.lastGoodOffset = offset;
        for (RRSet rrs : this.shuffleRRSets(this.answer.values())) {
            rrs.fixTTL();
            rrs.shuffle();
            for (ResourceRecord rr : rrs) {
                offset = rr.appendToWireWithCompression(wire, offset, compressionTable);
            }
            if (offset < udpPayloadSize) {
                partial.lastGoodOffset = offset;
                partial.anscount += rrs.size();
                continue;
            }
            return offset;
        }
        if (!omitAuthority) {
            for (RRSet rrs : this.shuffleRRSets(this.authority.values())) {
                rrs.fixTTL();
                rrs.shuffle();
                for (ResourceRecord rr : rrs) {
                    offset = rr.appendToWireWithCompression(wire, offset, compressionTable);
                }
                if (offset < udpPayloadSize) {
                    partial.lastGoodOffset = offset;
                    partial.authcount += rrs.size();
                    continue;
                }
                return offset;
            }
        }
        if (this.ednsOptRecord != null) {
            offset = this.ednsOptRecord.appendToWireWithCompression(wire, offset, compressionTable);
        }
        if (offset < udpPayloadSize) {
            partial.lastGoodOffset = offset;
            ++partial.addcount;
        } else {
            return offset;
        }
        for (RRSet rrs : this.shuffleRRSets((Collection<RRSet>)var10_16)) {
            rrs.fixTTL();
            rrs.shuffle();
            for (ResourceRecord rr : rrs) {
                offset = rr.appendToWireWithCompression(wire, offset, compressionTable);
            }
            if (offset < udpPayloadSize) {
                partial.lastGoodOffset = offset;
                partial.addcount += rrs.size();
                continue;
            }
            return offset;
        }
        return offset;
    }

    private Collection<RRSet> shuffleRRSets(Collection<RRSet> rrSets) {
        ArrayList<RRSet> res = new ArrayList<RRSet>();
        ArrayList<RRSet> toShuffle = new ArrayList<RRSet>();
        for (RRSet rrs : rrSets) {
            if (rrs.getType() == 5 || rrs.getType() == 6) {
                res.add(rrs);
                continue;
            }
            toShuffle.add(rrs);
        }
        Collections.shuffle(toShuffle);
        res.addAll(toShuffle);
        return res;
    }

    private byte[] truncationResponse() throws IOException {
        ByteArrayOutputStream wire = new ByteArrayOutputStream();
        int offset = 0;
        wire.write(this.id >> 8 & 0xFF);
        wire.write(this.id & 0xFF);
        int flags = 0;
        if (this.isQueryResponse) {
            flags |= 0x80;
        }
        flags |= (this.opcode & 0xF) << 3;
        if (this.authAnswer) {
            flags |= 4;
        }
        flags |= 2;
        if (this.recursionDesired) {
            flags |= 1;
        }
        wire.write(flags);
        flags = 0;
        if (this.recursionAvailable) {
            flags |= 0x80;
        }
        wire.write(flags |= this.responseCode & 0xF);
        int qcount = this.questions.length;
        int anscount = 0;
        int authcount = 0;
        int addcount = 0;
        if (this.ednsOptRecord != null) {
            ++addcount;
        }
        wire.write(qcount >> 8 & 0xFF);
        wire.write(qcount & 0xFF);
        wire.write(anscount >> 8 & 0xFF);
        wire.write(anscount & 0xFF);
        wire.write(authcount >> 8 & 0xFF);
        wire.write(authcount & 0xFF);
        wire.write(addcount >> 8 & 0xFF);
        wire.write(addcount & 0xFF);
        offset += 12;
        HashMap<DomainName, Integer> compressionTable = new HashMap<DomainName, Integer>();
        for (Question q : this.questions) {
            offset = q.appendToWireWithCompression(wire, offset, compressionTable);
        }
        if (this.ednsOptRecord != null) {
            offset = this.ednsOptRecord.appendToWireWithCompression(wire, offset, compressionTable);
        }
        return wire.toByteArray();
    }

    private boolean authorityIsOmittable() {
        if (this.answer.size() == 0) {
            return false;
        }
        for (Question q : this.answer.keySet()) {
            if (q.getType() == 5) continue;
            return true;
        }
        for (Question q : this.questions) {
            if (q.getType() != 5 && q.getType() != 255) continue;
            return true;
        }
        return false;
    }

    public static void debugPrint(byte b) {
        if (b >= 32 && b <= 126) {
            System.err.print(' ');
            System.err.print((char)b);
        } else {
            System.err.print(HEX_VALUES[b >>> 4 & 0xF]);
            System.err.print(HEX_VALUES[b & 0xF]);
        }
    }

    public static void debugPrint(byte[] bytes) {
        int i = 0;
        block0: while (true) {
            for (int j = 0; j < 30; ++j) {
                Message.debugPrint(bytes[i++]);
                if (i >= bytes.length) break block0;
            }
            System.err.println();
        }
        System.err.println();
    }

    public void debugPrint() {
        try {
            Message.debugPrint(this.getDatagram(65535));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        byte[] empty = new byte[]{};
        try {
            SMALL_EDNS = new ResourceRecord(DomainName.ROOT, 41, 512, 0, empty, 0, 0);
            LARGE_EDNS = new ResourceRecord(DomainName.ROOT, 41, 4096, 0, empty, 0, 0);
            SMALL_EDNS_BADVERS = new ResourceRecord(DomainName.ROOT, 41, 512, 0x1000000, empty, 0, 0);
            LARGE_EDNS_BADVERS = new ResourceRecord(DomainName.ROOT, 41, 4096, 0x1000000, empty, 0, 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    private class PartialResults {
        int lastGoodOffset;
        int anscount;
        int authcount;
        int addcount;

        private PartialResults() {
        }
    }
}

