/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class BootstrapHandles {
    public static final int MAX_DEPTH = 20;
    public long lastUpdate;
    public Map<String, HandleRecord> handles;

    public BootstrapHandles() {
    }

    public BootstrapHandles(Map<String, HandleRecord> handles) {
        this.handles = handles;
        this.lastUpdate = System.currentTimeMillis();
    }

    public Set<SiteInfo> getSites(String preferredRoot) {
        if (preferredRoot == null) {
            preferredRoot = "0.NA/0.NA";
        }
        LinkedHashSet<SiteInfo> result = new LinkedHashSet<SiteInfo>();
        this.addSitesToSet(preferredRoot, result, new HashSet<String>(), 0);
        return result;
    }

    private void addSitesToSet(String handle, Set<SiteInfo> sites, Set<String> handlesVisited, int depth) {
        HandleValue[] serviceValues;
        if (!handlesVisited.add(handle)) {
            return;
        }
        HandleRecord record = this.handles.get(handle);
        if (record == null || record.getValues() == null) {
            return;
        }
        SiteInfo[] rootSites = Util.getSitesAndAltSitesFromValues(record.getValuesAsArray());
        if (rootSites != null) {
            for (SiteInfo site : rootSites) {
                sites.add(site);
            }
        }
        if (depth >= 20) {
            return;
        }
        for (HandleValue serviceValue : serviceValues = Util.filterValues(record.getValuesAsArray(), null, Common.SERVICE_HANDLE_TYPES)) {
            String serviceHandle = serviceValue.getDataAsString();
            this.addSitesToSet(serviceHandle, sites, handlesVisited, depth + 1);
        }
    }
}

