/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;
import net.handle.security.HdlSecurityProvider;

public class SessionInfo {
    private static int defaultTimeout = 86400;
    public int timeOut = 86400;
    public int sessionId;
    public byte[] sessionKey;
    public boolean encryptMessage = false;
    public boolean authenticateMessage = false;
    private int algorithmCode;
    private final byte majorProtocolVersion;
    private final byte minorProtocolVersion;
    public byte[] identityKeyHandle = null;
    public int identityKeyIndex = -1;
    private int lastTransactionTime;
    private Set<Integer> seenSessionCounters;
    private int earliestRecordedSeenSessionCounter;
    private final AtomicInteger sessionCounter = new AtomicInteger(1);

    @Deprecated
    public SessionInfo(int sessionid, byte[] sessionkey, byte[] idenHandle, int idenIndex, int majorProtocolVersion, int minorProtocolVersion) {
        this(sessionid, sessionkey, idenHandle, idenIndex, 1, majorProtocolVersion, minorProtocolVersion);
    }

    public SessionInfo(int sessionid, byte[] sessionkey, byte[] idenHandle, int idenIndex, int algorithmCode, int majorProtocolVersion, int minorProtocolVersion) {
        this.identityKeyHandle = idenHandle;
        this.identityKeyIndex = idenIndex;
        this.algorithmCode = algorithmCode;
        this.sessionId = sessionid;
        this.sessionKey = sessionkey;
        this.lastTransactionTime = (int)(System.currentTimeMillis() / 1000L);
        this.timeOut = defaultTimeout;
        this.majorProtocolVersion = (byte)majorProtocolVersion;
        this.minorProtocolVersion = (byte)minorProtocolVersion;
        if (AbstractMessage.hasEqualOrGreaterVersion(majorProtocolVersion, minorProtocolVersion, 2, 5)) {
            this.setUpSeenSessionCounters();
        }
    }

    public int getNextSessionCounter() {
        return this.sessionCounter.getAndIncrement();
    }

    private void setUpSeenSessionCounters() {
        this.seenSessionCounters = Collections.newSetFromMap(new LinkedHashMap<Integer, Boolean>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, Boolean> eldest) {
                if (this.size() < 200) {
                    return false;
                }
                Iterator iter = this.keySet().iterator();
                iter.next();
                SessionInfo.this.earliestRecordedSeenSessionCounter = (Integer)iter.next();
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionCounter(int sessionCounter, boolean enforceUniqueness) throws HandleException {
        if (this.seenSessionCounters == null) {
            return;
        }
        if (sessionCounter == 0) {
            return;
        }
        Set<Integer> set = this.seenSessionCounters;
        synchronized (set) {
            if (!enforceUniqueness) {
                this.seenSessionCounters.add(sessionCounter);
                return;
            }
            if (sessionCounter <= this.earliestRecordedSeenSessionCounter || !this.seenSessionCounters.add(sessionCounter)) {
                throw new HandleException(28, "Duplicate session counter " + sessionCounter + " in session " + this.sessionId);
            }
        }
    }

    public int getEncryptionAlgorithmCode() {
        return this.algorithmCode;
    }

    public void setEncryptionAlgorithmCode(int algCode) {
        switch (algCode) {
            case 1: 
            case 2: 
            case 3: {
                this.algorithmCode = algCode;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid algorithm ID: " + algCode);
            }
        }
    }

    public byte[] encryptBuffer(byte[] buf, int offset, int len) throws HandleException {
        try {
            boolean legacy;
            HdlSecurityProvider provider = HdlSecurityProvider.getInstance();
            if (provider == null) {
                throw new HandleException(14, "Encryption/Key generation engine missing");
            }
            Cipher encryptCipher = provider.getCipher(this.algorithmCode, this.sessionKey, 1, null, this.majorProtocolVersion, this.minorProtocolVersion);
            byte[] ciphertext = encryptCipher.doFinal(buf, offset, len);
            boolean bl = legacy = !AbstractMessage.hasEqualOrGreaterVersion(this.majorProtocolVersion, this.minorProtocolVersion, 2, 4);
            if (legacy) {
                return ciphertext;
            }
            byte[] iv = encryptCipher.getIV();
            if (iv == null) {
                iv = new byte[]{};
            }
            return Util.concat(iv, ciphertext);
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(26, "Error encrypting buffer", e);
        }
    }

    public byte[] decryptBuffer(byte[] buf, int offset, int len) throws HandleException {
        try {
            HdlSecurityProvider provider = HdlSecurityProvider.getInstance();
            if (provider == null) {
                throw new HandleException(14, "Encryption/Key generation engine missing");
            }
            boolean legacy = !AbstractMessage.hasEqualOrGreaterVersion(this.majorProtocolVersion, this.minorProtocolVersion, 2, 4);
            byte[] iv = null;
            if (!legacy) {
                int ivSize = provider.getIvSize(this.algorithmCode, this.majorProtocolVersion, this.minorProtocolVersion);
                if (ivSize > 0) {
                    iv = Util.substring(buf, offset, offset + ivSize);
                }
                offset += ivSize;
                len -= ivSize;
            }
            Cipher decryptCipher = provider.getCipher(this.algorithmCode, this.sessionKey, 2, iv, this.majorProtocolVersion, this.minorProtocolVersion);
            return decryptCipher.doFinal(buf, offset, len);
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(26, "Error decrypting buffer", e);
        }
    }

    public boolean isSessionAnonymous() {
        return this.identityKeyHandle == null || this.identityKeyIndex == -1;
    }

    public void setTimeOut(int newTimeout) {
        if (newTimeout > 0) {
            this.timeOut = newTimeout;
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(byte[] sessionkey) {
        this.sessionKey = sessionkey;
    }

    public boolean getEncryptedMesssageFlag() {
        return this.encryptMessage;
    }

    public boolean getAuthenticateMessageFlag() {
        return this.authenticateMessage;
    }

    public void setEncryptedMesssageFlag(boolean flag) {
        this.encryptMessage = flag;
    }

    public void setAuthenticateMessageFlag(boolean flag) {
        this.authenticateMessage = flag;
    }

    public byte getMajorProtocolVersion() {
        return this.majorProtocolVersion;
    }

    public byte getMinorProtocolVersion() {
        return this.minorProtocolVersion;
    }

    public void touch() {
        this.lastTransactionTime = (int)(System.currentTimeMillis() / 1000L);
    }

    public final boolean hasExpired() {
        return (long)this.lastTransactionTime < System.currentTimeMillis() / 1000L - (long)this.timeOut;
    }

    public static void setDefaultTimeout(int maxSessionTimeout) {
        defaultTimeout = maxSessionTimeout;
    }

    public static int getDefaultTimeout() {
        return defaultTimeout;
    }

    public int getSessionID() {
        return this.sessionId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authenticateMessage ? 1231 : 1237);
        result = 31 * result + (this.encryptMessage ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.identityKeyHandle);
        result = 31 * result + this.identityKeyIndex;
        result = 31 * result + this.sessionId;
        result = 31 * result + Arrays.hashCode(this.sessionKey);
        result = 31 * result + this.timeOut;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionInfo other = (SessionInfo)obj;
        if (this.authenticateMessage != other.authenticateMessage) {
            return false;
        }
        if (this.encryptMessage != other.encryptMessage) {
            return false;
        }
        if (!Arrays.equals(this.identityKeyHandle, other.identityKeyHandle)) {
            return false;
        }
        if (this.identityKeyIndex != other.identityKeyIndex) {
            return false;
        }
        if (this.sessionId != other.sessionId) {
            return false;
        }
        if (!Arrays.equals(this.sessionKey, other.sessionKey)) {
            return false;
        }
        return this.timeOut == other.timeOut;
    }
}

