/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LRUCacheTable<K, V>
extends AbstractMap<K, V> {
    private int maxsize;
    private Map<K, V> map;

    public LRUCacheTable(int maxsize) {
        this.maxsize = maxsize;
        this.map = Collections.synchronizedMap(new LinkedHashMap<K, V>(maxsize, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return super.size() >= LRUCacheTable.this.maxsize;
            }
        });
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public int getMaxSize() {
        return this.maxsize;
    }

    public void setMaxSize(int newsize) {
        this.maxsize = newsize;
    }

    @Override
    public V put(K key, V val) {
        return this.map.put(key, val);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }
}

