/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import net.cnri.util.FastDateFormat;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class X509HSCertificateGenerator {
    private static SecureRandom random = new SecureRandom();
    private static final Date notBefore;
    private static final Date notAfter;

    public static X509Certificate generate(String handle, PublicKey pubKey, PrivateKey privKey) throws Exception {
        if (handle == null) {
            return X509HSCertificateGenerator.generateWithUid(null, pubKey, privKey);
        }
        int colon = handle.indexOf(58);
        if (colon < 0) {
            return X509HSCertificateGenerator.generateWithUid(handle, pubKey, privKey);
        }
        String maybeIndex = handle.substring(0, colon);
        if (X509HSCertificateGenerator.isDigits(maybeIndex)) {
            return X509HSCertificateGenerator.generateWithUid("0:" + handle, pubKey, privKey);
        }
        return X509HSCertificateGenerator.generateWithUid(handle, pubKey, privKey);
    }

    public static X509Certificate generate(String handle, int index, PublicKey pubKey, PrivateKey privKey) throws Exception {
        return X509HSCertificateGenerator.generateWithUid("" + index + ":" + handle, pubKey, privKey);
    }

    public static X509Certificate generate(ValueReference valRef, PublicKey pubKey, PrivateKey privKey) throws Exception {
        return X509HSCertificateGenerator.generateWithUid("" + valRef.index + ":" + Util.decodeString(valRef.handle), pubKey, privKey);
    }

    public static X509Certificate generateWithUid(String uid, PublicKey pubKey, PrivateKey privKey) throws Exception {
        return X509HSCertificateGenerator.generateWithCnAndUid(null, uid, pubKey, privKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate generateWithCnAndUid(String cn, String uid, PublicKey pubKey, PrivateKey privKey) throws Exception {
        SubjectPublicKeyInfo pubKeyInfo;
        X500Name name;
        if (uid == null) {
            if (cn == null) {
                cn = "anonymous";
            }
            name = new X500Name(new RDN[]{new RDN(new AttributeTypeAndValue(BCStyle.CN, (ASN1Encodable)new DERUTF8String(cn)))});
        } else {
            name = cn == null ? new X500Name(new RDN[]{new RDN(new AttributeTypeAndValue(BCStyle.UID, (ASN1Encodable)new DERUTF8String(uid)))}) : new X500Name(new RDN[]{new RDN(new AttributeTypeAndValue(BCStyle.CN, (ASN1Encodable)new DERUTF8String(cn))), new RDN(new AttributeTypeAndValue(BCStyle.UID, (ASN1Encodable)new DERUTF8String(uid)))});
        }
        try (ASN1InputStream in = new ASN1InputStream(pubKey.getEncoded());){
            pubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)in.readObject());
        }
        byte[] serialBytes = new byte[20];
        random.nextBytes(serialBytes);
        serialBytes[0] = (byte)(serialBytes[0] & 0x7F);
        X509v3CertificateBuilder builder = new X509v3CertificateBuilder(name, new BigInteger(serialBytes), notBefore, notAfter, name, pubKeyInfo);
        ContentSigner signer = new JcaContentSignerBuilder(Util.getDefaultSigId(privKey.getAlgorithm())).build(privKey);
        X509CertificateHolder certHolder = builder.build(signer);
        return new JcaX509CertificateConverter().getCertificate(certHolder);
    }

    public static void storeCertAndKey(KeyStore keyStore, Certificate cert, PrivateKey privKey, String alias, String keyPass) throws KeyStoreException {
        keyStore.setKeyEntry(alias, privKey, keyPass.toCharArray(), new Certificate[]{cert});
    }

    private static void addBCProviderIfNeeded() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static void writeCertAsPem(Writer writer, Certificate cert) throws IOException {
        X509HSCertificateGenerator.addBCProviderIfNeeded();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter(writer);){
            pemWriter.writeObject((Object)cert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate readCertAsPem(Reader reader) throws IOException {
        X509HSCertificateGenerator.addBCProviderIfNeeded();
        PEMParser pemReader = new PEMParser(reader);
        try {
            Object obj = pemReader.readObject();
            if (obj instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)obj;
                return x509Certificate;
            }
            if (obj instanceof X509CertificateHolder) {
                X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)obj);
                return x509Certificate;
            }
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        catch (CertificateException e) {
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        finally {
            pemReader.close();
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] readCertChainAsPem(Reader reader) throws IOException {
        X509HSCertificateGenerator.addBCProviderIfNeeded();
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        PEMParser pemReader = new PEMParser(reader);
        try {
            Object obj;
            while ((obj = pemReader.readObject()) != null) {
                if (obj instanceof X509Certificate) {
                    certs.add((X509Certificate)obj);
                    continue;
                }
                if (!(obj instanceof X509CertificateHolder)) continue;
                certs.add(new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)obj));
            }
        }
        catch (CertificateException e) {
            X509Certificate[] x509CertificateArray = null;
            return x509CertificateArray;
        }
        finally {
            pemReader.close();
            reader.close();
        }
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    private static boolean isDigits(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        random.setSeed(System.nanoTime());
        try {
            notBefore = new Date(FastDateFormat.parseUtc((String)"20000101000000Z"));
            notAfter = new Date(FastDateFormat.parseUtc((String)"99991231235959Z"));
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }
}

