/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.dona.doip.BadDoipException;
import net.dona.doip.InDoipMessage;
import net.dona.doip.InDoipSegment;
import net.dona.doip.InDoipSegmentFromInputStream;

public class InDoipMessageImpl
implements InDoipMessage {
    private final PushbackInputStream in;
    private final SpliteratorImpl spliterator;
    private InDoipSegment curr;
    private boolean isClosed;
    private BadDoipException terminalException;
    private CompletableFuture<?> completer;

    public InDoipMessageImpl(InputStream in) {
        this.in = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in);
        this.spliterator = new SpliteratorImpl();
    }

    public void setCompleter(CompletableFuture<?> completer) {
        this.completer = completer;
    }

    public BadDoipException getTerminalException() {
        return this.terminalException;
    }

    @Override
    public Iterator<InDoipSegment> iterator() {
        return Spliterators.iterator(this.spliterator);
    }

    @Override
    public void close() {
        if (this.terminalException != null) {
            return;
        }
        while (!this.isClosed) {
            this.spliterator.tryAdvance((Consumer<? super InDoipSegment>)((Consumer<InDoipSegment>)x -> {}));
        }
    }

    @Override
    public Spliterator<InDoipSegment> spliterator() {
        return this.spliterator;
    }

    @Override
    public Stream<InDoipSegment> stream() {
        Stream<InDoipSegment> stream = StreamSupport.stream(this.spliterator, false);
        return (Stream)stream.onClose(this::close);
    }

    private BadDoipException terminalException(String message) {
        this.terminalException = new BadDoipException(message);
        if (this.completer != null) {
            this.completer.completeExceptionally(this.terminalException);
        }
        return this.terminalException;
    }

    private void skipToNewline() throws IOException {
        int ch;
        do {
            if ((ch = this.in.read()) == -1) {
                throw this.terminalException("end of input before newline");
            }
            if (ch != 10) continue;
            return;
        } while (ch == 32 || ch == 9 || ch == 13);
        throw this.terminalException("expected whitespace until newline");
    }

    private class HashTerminatedInputStream
    extends InputStream {
        boolean sawNewline = false;
        boolean isDone;

        private HashTerminatedInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (InDoipMessageImpl.this.terminalException != null) {
                throw InDoipMessageImpl.this.terminalException;
            }
            if (this.isDone) {
                return -1;
            }
            int ch = InDoipMessageImpl.this.in.read();
            if (ch == -1) {
                throw InDoipMessageImpl.this.terminalException("end of input reading JSON segment");
            }
            if (ch == 35 && this.sawNewline) {
                InDoipMessageImpl.this.skipToNewline();
                InDoipMessageImpl.this.curr = null;
                this.isDone = true;
                return -1;
            }
            this.sawNewline = ch == 10;
            return ch;
        }

        @Override
        public void close() throws IOException {
            while (!this.isDone) {
                this.skip(Long.MAX_VALUE);
            }
            super.close();
        }
    }

    private class ChunkedBytesInputStream
    extends InputStream {
        int currentSize = -1;
        boolean isDone;

        private ChunkedBytesInputStream() {
        }

        @Override
        public int read() throws IOException {
            int ch;
            if (InDoipMessageImpl.this.terminalException != null) {
                throw InDoipMessageImpl.this.terminalException;
            }
            if (this.isDone) {
                return -1;
            }
            if (this.currentSize > 0) {
                int res = InDoipMessageImpl.this.in.read();
                --this.currentSize;
                if (res < 0) {
                    throw InDoipMessageImpl.this.terminalException("end of input while reading chunk");
                }
                return res;
            }
            if (this.currentSize == 0) {
                InDoipMessageImpl.this.skipToNewline();
                this.currentSize = -1;
            }
            if ((ch = InDoipMessageImpl.this.in.read()) == 35) {
                InDoipMessageImpl.this.skipToNewline();
                InDoipMessageImpl.this.curr = null;
                this.isDone = true;
                return -1;
            }
            if (ch == 48) {
                throw InDoipMessageImpl.this.terminalException("zero at start of chunk size");
            }
            StringBuilder sb = new StringBuilder();
            while (true) {
                if (ch == -1) {
                    throw InDoipMessageImpl.this.terminalException("end of input reading chunk size");
                }
                if (ch == 10 || ch == 32 || ch == 9 || ch == 13) {
                    if (sb.length() == 0) {
                        throw InDoipMessageImpl.this.terminalException("missing chunk size");
                    }
                    this.currentSize = Integer.parseInt(sb.toString());
                    if (this.currentSize <= 0) {
                        throw InDoipMessageImpl.this.terminalException("overlong chunk size");
                    }
                    if (ch != 10) {
                        InDoipMessageImpl.this.skipToNewline();
                    }
                    return this.read();
                }
                if (ch < 48 || ch > 57) {
                    throw InDoipMessageImpl.this.terminalException("unexpected character in chunk size");
                }
                sb.append((char)ch);
                if (sb.length() >= String.valueOf(Integer.MAX_VALUE).length()) {
                    throw InDoipMessageImpl.this.terminalException("overlong chunk size");
                }
                ch = InDoipMessageImpl.this.in.read();
            }
        }

        @Override
        public void close() throws IOException {
            while (this.currentSize > 0) {
                this.skip(Long.MAX_VALUE);
            }
            super.close();
        }
    }

    private class SpliteratorImpl
    extends Spliterators.AbstractSpliterator<InDoipSegment> {
        public SpliteratorImpl() {
            super(Long.MAX_VALUE, 1296);
        }

        @Override
        public boolean tryAdvance(Consumer<? super InDoipSegment> action) {
            if (InDoipMessageImpl.this.terminalException != null) {
                throw new UncheckedIOException(InDoipMessageImpl.this.terminalException);
            }
            if (InDoipMessageImpl.this.isClosed) {
                return false;
            }
            try {
                while (InDoipMessageImpl.this.curr != null && InDoipMessageImpl.this.curr.getInputStream().skip(Long.MAX_VALUE) > 0L) {
                }
                int ch = InDoipMessageImpl.this.in.read();
                if (ch == -1) {
                    throw InDoipMessageImpl.this.terminalException("end of input before terminal empty segment");
                }
                if (ch == 35) {
                    InDoipMessageImpl.this.skipToNewline();
                    InDoipMessageImpl.this.isClosed = true;
                    if (InDoipMessageImpl.this.completer != null) {
                        InDoipMessageImpl.this.completer.complete(null);
                    }
                    return false;
                }
                if (ch == 64) {
                    InDoipMessageImpl.this.skipToNewline();
                    InDoipMessageImpl.this.curr = new InDoipSegmentFromInputStream(false, new ChunkedBytesInputStream());
                } else {
                    InDoipMessageImpl.this.in.unread(ch);
                    InDoipMessageImpl.this.curr = new InDoipSegmentFromInputStream(true, new HashTerminatedInputStream());
                }
                action.accept(InDoipMessageImpl.this.curr);
                return true;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

