/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.dona.doip.BadDoipException;
import net.dona.doip.InDoipSegment;

public class InDoipSegmentFromInputStream
implements InDoipSegment {
    private final boolean isJson;
    private final InputStream in;
    private JsonElement json;

    public InDoipSegmentFromInputStream(boolean isJson, InputStream in) {
        this.isJson = isJson;
        this.in = in;
    }

    @Override
    public boolean isJson() {
        return this.isJson;
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public JsonElement getJson() throws IOException {
        JsonElement jsonElement;
        if (!this.isJson) {
            throw new IllegalStateException("not a JSON segment");
        }
        if (this.json != null) {
            return this.json;
        }
        InputStreamReader isr = new InputStreamReader(this.in, StandardCharsets.UTF_8);
        try {
            jsonElement = this.json = new JsonParser().parse((Reader)isr);
        }
        catch (Throwable throwable) {
            try {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonParseException e) {
                throw new BadDoipException("invalid JSON", e);
            }
        }
        isr.close();
        return jsonElement;
    }
}

