/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client;

import com.google.gson.JsonObject;
import java.security.PrivateKey;
import java.security.SecureRandom;
import net.dona.doip.client.AuthenticationInfo;
import net.dona.doip.client.DoipException;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.JsonWebSignatureFactory;
import net.handle.hdllib.trust.TrustException;
import org.apache.commons.codec.binary.Hex;

public class PrivateKeyAuthenticationInfo
implements AuthenticationInfo {
    private final String clientId;
    private final PrivateKey privateKey;
    private final SecureRandom random;
    private final String asUserId;

    public PrivateKeyAuthenticationInfo(String clientId, PrivateKey privateKey) {
        this(clientId, privateKey, null);
    }

    public PrivateKeyAuthenticationInfo(String clientId, PrivateKey privateKey, String asUserId) {
        this.clientId = clientId;
        this.privateKey = privateKey;
        this.random = new SecureRandom();
        this.asUserId = asUserId;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public JsonObject getAuthentication() throws DoipException {
        JsonObject authentication = new JsonObject();
        try {
            String token = this.createBearerToken(this.privateKey, this.clientId);
            authentication.addProperty("token", token);
            if (this.asUserId != null) {
                authentication.addProperty("asUserId", this.asUserId);
            }
            return authentication;
        }
        catch (TrustException te) {
            throw new DoipException(te);
        }
    }

    private String createBearerToken(PrivateKey privateKey, String iss) throws TrustException {
        long nowSeconds = System.currentTimeMillis() / 1000L;
        JsonObject claims = new JsonObject();
        claims.addProperty("iss", iss);
        claims.addProperty("sub", iss);
        claims.addProperty("jti", this.generateJti());
        claims.addProperty("iat", (Number)nowSeconds);
        claims.addProperty("exp", (Number)(nowSeconds + 600L));
        String claimsJson = claims.toString();
        JsonWebSignature jwt = JsonWebSignatureFactory.getInstance().create(claimsJson, privateKey);
        return jwt.serialize();
    }

    private String generateJti() {
        byte[] bytes = new byte[10];
        this.random.nextBytes(bytes);
        String hex = Hex.encodeHexString((byte[])bytes);
        return hex;
    }
}

