/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.dona.doip.BadDoipException;
import net.dona.doip.DoipRequestHeaders;
import net.dona.doip.DoipRequestHeadersWithRequestId;
import net.dona.doip.DoipResponseHeadersWithRequestId;
import net.dona.doip.InDoipMessage;
import net.dona.doip.InDoipMessageImpl;
import net.dona.doip.InDoipSegment;
import net.dona.doip.OutDoipMessage;
import net.dona.doip.OutDoipMessageImpl;
import net.dona.doip.client.transport.DoipClientResponse;
import net.dona.doip.client.transport.DoipConnection;
import net.dona.doip.client.transport.DoipExchange;
import net.dona.doip.util.GsonUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoipConnectionImpl
implements DoipConnection {
    private static final Logger logger = LoggerFactory.getLogger(DoipConnectionImpl.class);
    private static final AtomicInteger connectionCount = new AtomicInteger(1);
    private final Socket socket;
    private final Semaphore outputLock = new Semaphore(1, true);
    private final ConcurrentMap<String, CompletableFuture<DoipClientResponse>> outstandingRequests = new ConcurrentHashMap<String, CompletableFuture<DoipClientResponse>>();
    private volatile CountDownLatch requestWaitLatch = new CountDownLatch(1);
    private final ExecutorService execServ;
    private DoipResponseHeadersWithRequestId initialSegment;
    private CompletableFuture<?> responseReadingCompleter;
    private volatile boolean isClosed;

    public DoipConnectionImpl(Socket socket) {
        this.socket = socket;
        this.execServ = Executors.newSingleThreadExecutor(r -> new Thread(r, "doip-connection-monitor-" + connectionCount.getAndIncrement()));
        this.execServ.submit(this::monitor);
    }

    private void monitor() {
        try {
            int ch;
            PushbackInputStream in = new PushbackInputStream(new BufferedInputStream(this.socket.getInputStream()));
            while (this.waitForRequest() && (ch = in.read()) > -1) {
                if (this.isClosed) {
                    return;
                }
                in.unread(ch);
                InDoipMessageImpl inDoipMessage = new InDoipMessageImpl(in);
                boolean found = inDoipMessage.spliterator().tryAdvance(this::handleInitialSegment);
                if (found) {
                    CompletableFuture responseFuture = (CompletableFuture)this.outstandingRequests.remove(this.initialSegment.requestId);
                    if (this.outstandingRequests.isEmpty()) {
                        this.requestWaitLatch = new CountDownLatch(1);
                    }
                    if (responseFuture == null) {
                        throw new BadDoipException("No request " + this.initialSegment.requestId);
                    }
                    this.responseReadingCompleter = new CompletableFuture();
                    inDoipMessage.setCompleter(this.responseReadingCompleter);
                    responseFuture.complete(new DoipClientResponse(this.initialSegment, inDoipMessage));
                    if (this.isClosed) {
                        return;
                    }
                    this.responseReadingCompleter.join();
                    this.responseReadingCompleter = null;
                    continue;
                }
                throw new BadDoipException("empty response received");
            }
        }
        catch (Exception e) {
            if (this.isClosed) {
                return;
            }
            if (e instanceof CompletionException || e instanceof UncheckedIOException) {
                logger.error("Error in DOIP response stream", e.getCause());
            } else if (!(e instanceof CancellationException)) {
                logger.error("Error in DOIP response stream", (Throwable)e);
            }
            try {
                this.closeWithoutWaiting();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean waitForRequest() {
        if (this.outstandingRequests.isEmpty()) {
            try {
                this.requestWaitLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return !this.isClosed;
    }

    private void handleInitialSegment(InDoipSegment segment) {
        try {
            if (!segment.isJson()) {
                throw new BadDoipException("expected JSON segment");
            }
            this.initialSegment = (DoipResponseHeadersWithRequestId)GsonUtility.getGson().fromJson(segment.getJson(), DoipResponseHeadersWithRequestId.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DoipClientResponse sendCompactRequest(DoipRequestHeaders request) throws IOException {
        String requestId;
        if (this.isClosed) {
            throw new IOException("closed");
        }
        DoipRequestHeadersWithRequestId requestWithRequestId = new DoipRequestHeadersWithRequestId(request);
        requestWithRequestId.requestId = requestId = UUID.randomUUID().toString();
        CompletableFuture completer = new CompletableFuture();
        this.outstandingRequests.put(requestId, completer);
        this.requestWaitLatch.countDown();
        try {
            this.outputLock.acquire();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (this.isClosed) {
            throw new IOException("closed");
        }
        try (OutDoipMessageImpl outDoipMessage = new OutDoipMessageImpl(new BufferedOutputStream(this.socket.getOutputStream()));){
            outDoipMessage.writeJson(GsonUtility.getGson().toJson((Object)requestWithRequestId));
        }
        finally {
            this.outputLock.release();
        }
        try {
            return (DoipClientResponse)completer.join();
        }
        catch (Exception e) {
            this.unwrapAndThrow(e);
            throw e;
        }
    }

    @Override
    public DoipClientResponse sendRequest(DoipRequestHeaders request, InDoipMessage in) throws IOException {
        String requestId;
        if (this.isClosed) {
            throw new IOException("closed");
        }
        DoipRequestHeadersWithRequestId requestWithRequestId = new DoipRequestHeadersWithRequestId(request);
        requestWithRequestId.requestId = requestId = UUID.randomUUID().toString();
        CompletableFuture completer = new CompletableFuture();
        this.outstandingRequests.put(requestId, completer);
        this.requestWaitLatch.countDown();
        try {
            this.outputLock.acquire();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (this.isClosed) {
            throw new IOException("closed");
        }
        try (OutDoipMessageImpl outDoipMessage = new OutDoipMessageImpl(new BufferedOutputStream(this.socket.getOutputStream()));){
            outDoipMessage.writeJson(GsonUtility.getGson().toJson((Object)requestWithRequestId));
            for (InDoipSegment segment : in) {
                if (this.isClosed) {
                    throw new IOException("closed");
                }
                if (segment.isJson()) {
                    outDoipMessage.writeJson(segment.getJson());
                    continue;
                }
                outDoipMessage.writeBytes(segment.getInputStream());
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        finally {
            this.outputLock.release();
        }
        try {
            return (DoipClientResponse)completer.join();
        }
        catch (Exception e) {
            this.unwrapAndThrow(e);
            throw e;
        }
    }

    @Override
    public DoipExchange sendRequestToExchange(DoipRequestHeaders request) throws IOException {
        String requestId;
        if (this.isClosed) {
            throw new IOException("closed");
        }
        DoipRequestHeadersWithRequestId requestWithRequestId = new DoipRequestHeadersWithRequestId(request);
        requestWithRequestId.requestId = requestId = UUID.randomUUID().toString();
        final CompletableFuture completer = new CompletableFuture();
        this.outstandingRequests.put(requestId, completer);
        this.requestWaitLatch.countDown();
        try {
            this.outputLock.acquire();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (this.isClosed) {
            throw new IOException("closed");
        }
        final OutDoipMessageImpl outDoipMessage = new OutDoipMessageImpl(new BufferedOutputStream(this.socket.getOutputStream())){

            @Override
            public void close() throws IOException {
                super.close();
                DoipConnectionImpl.this.outputLock.release();
            }
        };
        outDoipMessage.writeJson(GsonUtility.getGson().toJson((Object)requestWithRequestId));
        return new DoipExchange(){

            @Override
            public DoipClientResponse getResponse() throws IOException {
                if (DoipConnectionImpl.this.isClosed) {
                    throw new IOException("closed");
                }
                try {
                    return (DoipClientResponse)completer.join();
                }
                catch (Exception e) {
                    DoipConnectionImpl.this.unwrapAndThrow(e);
                    throw e;
                }
            }

            @Override
            public OutDoipMessage getRequestOutgoingMessage() {
                return outDoipMessage;
            }

            @Override
            public void close() {
                try {
                    outDoipMessage.close();
                }
                catch (Exception e) {
                    logger.warn("Error closing", (Throwable)e);
                }
                try {
                    this.getResponse().close();
                }
                catch (Exception e) {
                    logger.warn("Error closing", (Throwable)e);
                }
            }
        };
    }

    @Override
    public void close() {
        this.closeWithoutWaiting();
        try {
            this.execServ.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            logger.warn("Error closing", (Throwable)e);
        }
    }

    private void closeWithoutWaiting() {
        this.isClosed = true;
        for (CompletableFuture future : this.outstandingRequests.values()) {
            future.cancel(false);
        }
        try {
            this.socket.close();
        }
        catch (Exception e) {
            logger.warn("Error closing", (Throwable)e);
        }
        CompletableFuture<?> completer = this.responseReadingCompleter;
        if (completer != null) {
            completer.cancel(false);
        }
        this.requestWaitLatch.countDown();
        try {
            this.execServ.shutdown();
        }
        catch (Exception e) {
            logger.warn("Error closing", (Throwable)e);
        }
        for (CompletableFuture future : this.outstandingRequests.values()) {
            future.cancel(false);
        }
    }

    private void unwrapAndThrow(Exception e) throws IOException {
        if (e instanceof CompletionException) {
            if (e.getCause() instanceof Exception) {
                this.unwrapAndThrow((Exception)e.getCause());
            } else {
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw (CompletionException)e;
            }
        }
        if (e instanceof UncheckedIOException) {
            this.unwrapAndThrow(((UncheckedIOException)e).getCause());
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        throw new AssertionError((Object)e);
    }
}

