/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.client.transport;

import java.io.IOException;
import net.dona.doip.DoipRequestHeaders;
import net.dona.doip.InDoipMessage;
import net.dona.doip.client.transport.DoipClientResponse;
import net.dona.doip.client.transport.DoipConnection;
import net.dona.doip.client.transport.DoipExchange;

public class ReleaseOnceDoipConnection
implements DoipConnection {
    private final DoipConnection conn;
    private volatile boolean isReleased = false;

    public ReleaseOnceDoipConnection(DoipConnection conn) {
        this.conn = conn;
    }

    public synchronized void release() {
        if (this.isReleased) {
            return;
        }
        this.isReleased = true;
    }

    DoipConnection getConnection() {
        return this.conn;
    }

    @Override
    public boolean isClosed() {
        return this.conn.isClosed();
    }

    @Override
    public DoipClientResponse sendCompactRequest(DoipRequestHeaders request) throws IOException {
        if (this.isReleased) {
            throw new IllegalStateException("Attempt to use released connection");
        }
        return this.conn.sendCompactRequest(request);
    }

    @Override
    public DoipClientResponse sendRequest(DoipRequestHeaders request, InDoipMessage in) throws IOException {
        if (this.isReleased) {
            throw new IllegalStateException("Attempt to use released connection");
        }
        return this.conn.sendRequest(request, in);
    }

    @Override
    public DoipExchange sendRequestToExchange(DoipRequestHeaders request) throws IOException {
        if (this.isReleased) {
            throw new IllegalStateException("Attempt to use released connection");
        }
        return this.conn.sendRequestToExchange(request);
    }

    @Override
    public void close() {
        this.conn.close();
    }
}

