/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.dona.doip.BadDoipException;
import net.dona.doip.DoipRequestHeadersWithRequestId;
import net.dona.doip.InDoipMessage;
import net.dona.doip.InDoipMessageFromJson;
import net.dona.doip.InDoipSegment;
import net.dona.doip.server.DoipServerRequest;
import net.dona.doip.util.GsonUtility;

public class DoipServerRequestImpl
implements DoipServerRequest {
    private final InDoipMessage inDoipMessage;
    private final String clientCertId;
    private final PublicKey clientCertPublicKey;
    private final X509Certificate[] clientCertChain;
    private DoipRequestHeadersWithRequestId doipRequestHeaders;
    private InDoipMessage inputFromHeadersJson;
    private static final List<String> acceptableRequestProperties;

    public DoipServerRequestImpl(InDoipMessage inDoipMessage, String clientCertId, PublicKey clientCertPublicKey, X509Certificate[] clientCertChain) throws IOException {
        this.inDoipMessage = inDoipMessage;
        this.clientCertId = clientCertId;
        this.clientCertPublicKey = clientCertPublicKey;
        this.clientCertChain = clientCertChain;
        try {
            boolean found = inDoipMessage.spliterator().tryAdvance(this::handleFirstSegmentUnchecked);
            if (!found) {
                throw new BadDoipException("no initial segment in request");
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private void handleFirstSegmentUnchecked(InDoipSegment segment) {
        try {
            this.handleFirstSegment(segment);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void handleFirstSegment(InDoipSegment segment) throws IOException {
        if (!segment.isJson()) {
            throw new BadDoipException("Request initial segment must be JSON");
        }
        JsonElement el = segment.getJson();
        try {
            if (!el.isJsonObject()) {
                throw new BadDoipException("Request initial segment must be a JSON object");
            }
            this.checkProperties(el.getAsJsonObject());
            this.doipRequestHeaders = (DoipRequestHeadersWithRequestId)GsonUtility.getGson().fromJson(el, DoipRequestHeadersWithRequestId.class);
        }
        catch (JsonParseException e) {
            throw new BadDoipException("Error parsing initial JSON of request", e);
        }
        if (this.doipRequestHeaders.input != null) {
            boolean found = this.inDoipMessage.spliterator().tryAdvance(nextSegment -> {});
            if (found) {
                throw new BadDoipException("Extra segments after initial JSON with compact input");
            }
            this.inDoipMessage.close();
        }
    }

    private void checkProperties(JsonObject obj) throws BadDoipException {
        for (String key : obj.keySet()) {
            if (acceptableRequestProperties.contains(key)) continue;
            throw new BadDoipException("Unexpected request property " + key);
        }
    }

    public String getRequestId() {
        return this.doipRequestHeaders.requestId;
    }

    @Override
    public String getClientId() {
        return this.doipRequestHeaders.clientId;
    }

    @Override
    public String getTargetId() {
        return this.doipRequestHeaders.targetId;
    }

    @Override
    public String getOperationId() {
        return this.doipRequestHeaders.operationId;
    }

    @Override
    public JsonObject getAttributes() {
        return this.doipRequestHeaders.attributes;
    }

    @Override
    public JsonElement getAttribute(String key) {
        if (this.doipRequestHeaders.attributes == null) {
            return null;
        }
        return this.doipRequestHeaders.attributes.get(key);
    }

    @Override
    public String getAttributeAsString(String key) {
        if (this.doipRequestHeaders.attributes == null) {
            return null;
        }
        JsonElement el = this.doipRequestHeaders.attributes.get(key);
        if (el == null) {
            return null;
        }
        return el.getAsString();
    }

    @Override
    public JsonElement getAuthentication() {
        return this.doipRequestHeaders.authentication;
    }

    @Override
    public InDoipMessage getInput() {
        JsonElement json = this.doipRequestHeaders.input;
        if (json != null) {
            if (this.inputFromHeadersJson != null) {
                return this.inputFromHeadersJson;
            }
            this.inputFromHeadersJson = new InDoipMessageFromJson(json);
            return this.inputFromHeadersJson;
        }
        return this.inDoipMessage;
    }

    @Override
    public String getConnectionClientId() {
        return this.clientCertId;
    }

    @Override
    public PublicKey getConnectionPublicKey() {
        return this.clientCertPublicKey;
    }

    @Override
    public X509Certificate[] getConnectionCertificateChain() {
        return this.clientCertChain;
    }

    static {
        Field[] fields = DoipRequestHeadersWithRequestId.class.getFields();
        acceptableRequestProperties = Stream.of(fields).map(field -> field.getName()).collect(Collectors.toList());
    }
}

