/*
 * Decompiled with CFR 0.152.
 */
package net.dona.doip.util.tls;

import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import net.dona.doip.util.tls.X509IdParser;

public class TrustManagerForSpecifiedServerIdAndKeys
implements X509TrustManager {
    private final String id;
    private final List<PublicKey> keys;

    public TrustManagerForSpecifiedServerIdAndKeys(String id, List<PublicKey> keys) {
        this.id = id;
        this.keys = keys;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("null or empty certificate chain");
        }
        this.authenticate(chain[0]);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("null or empty certificate chain");
        }
        this.authenticate(chain[0]);
    }

    private void authenticate(X509Certificate cert) throws CertificateException {
        try {
            String certId = X509IdParser.parseIdentityHandle(cert);
            if (certId == null) {
                throw new CertificateException("Could not parse identity from server certificate");
            }
            if (!certId.equals(this.id)) {
                throw new CertificateException("Unable to validate X509 certificate, id does not match expected id");
            }
            PublicKey certKey = cert.getPublicKey();
            if (this.keys == null || this.keys.contains(certKey)) {
                return;
            }
            throw new CertificateException("Unable to validate X509 certificate, public key does not match any of expected public keys");
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException("Exception validating X509 certificate", e);
        }
    }
}

