/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SimpleCommandLine {
    private final boolean groupSingleCharacterOptions;
    private final List<String> optionsExpectingArguments;
    private List<String> options = new ArrayList<String>();
    private Map<String, List<String>> optionArguments = new LinkedHashMap<String, List<String>>();
    private List<String> operands = new ArrayList<String>();
    private boolean parsed;

    public SimpleCommandLine(String ... optionsExpectingArguments) {
        this(false, optionsExpectingArguments);
    }

    public SimpleCommandLine(List<String> optionsExpectingArguments) {
        this(false, optionsExpectingArguments.toArray(new String[optionsExpectingArguments.size()]));
    }

    public SimpleCommandLine(boolean groupSingleCharacterOptions, List<String> optionsExpectingArguments) {
        this(groupSingleCharacterOptions, optionsExpectingArguments.toArray(new String[optionsExpectingArguments.size()]));
    }

    public SimpleCommandLine(boolean groupSingleCharacterOptions, String ... optionsExpectingArguments) {
        this.groupSingleCharacterOptions = groupSingleCharacterOptions;
        this.optionsExpectingArguments = Arrays.asList(optionsExpectingArguments);
    }

    private void putOptionArgument(String option, String optionArg) {
        List<String> optionArgs = this.optionArguments.get(option);
        if (optionArgs == null) {
            optionArgs = new ArrayList<String>();
            this.optionArguments.put(option, optionArgs);
        }
        optionArgs.add(optionArg);
    }

    public void parse(String[] args) {
        if (this.parsed) {
            throw new IllegalStateException();
        }
        boolean sawDoubleDash = false;
        for (int i = 0; i < args.length; ++i) {
            boolean skipNextArg;
            String arg = args[i];
            if (sawDoubleDash) {
                this.operands.add(arg);
                continue;
            }
            if ("--".equals(arg)) {
                sawDoubleDash = true;
                continue;
            }
            if (arg.equals("-") || !arg.startsWith("-")) {
                this.operands.add(arg);
                continue;
            }
            String nextArg = null;
            if (i + 1 < args.length) {
                nextArg = args[i + 1];
            }
            if (!(skipNextArg = this.parseOptionReturnTrueIfSkipNextArg(arg, nextArg))) continue;
            ++i;
        }
        this.preventFurtherModification();
        this.parsed = true;
    }

    private void preventFurtherModification() {
        this.options = Collections.unmodifiableList(this.options);
        this.operands = Collections.unmodifiableList(this.operands);
        for (Map.Entry<String, List<String>> entry : this.optionArguments.entrySet()) {
            this.optionArguments.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        this.optionArguments = Collections.unmodifiableMap(this.optionArguments);
    }

    private boolean parseOptionReturnTrueIfSkipNextArg(String arg, String nextArg) {
        boolean twoDashes = arg.startsWith("--");
        if (twoDashes || !this.groupSingleCharacterOptions) {
            return this.parseMultiCharOptionReturnTrueIfSkipNextArg(arg, nextArg);
        }
        return this.parseGroupedSingleCharOptionsReturnTrueIfSkipNextArg(arg, nextArg);
    }

    private boolean parseGroupedSingleCharOptionsReturnTrueIfSkipNextArg(String arg, String nextArg) {
        String prevOption = null;
        for (int j = 1; j < arg.length(); ++j) {
            String thisOption = arg.substring(j, j + 1);
            if (prevOption != null && thisOption.equals("=")) {
                this.putOptionArgument(prevOption, arg.substring(j + 1));
                return false;
            }
            this.options.add(thisOption);
            prevOption = thisOption;
            if (!this.optionsExpectingArguments.contains(thisOption)) continue;
            if (j + 1 == arg.length()) {
                if (nextArg == null) continue;
                this.putOptionArgument(thisOption, nextArg);
                return true;
            }
            String optionArg = arg.charAt(j + 1) == '=' ? arg.substring(j + 2) : arg.substring(j + 1);
            this.putOptionArgument(thisOption, optionArg);
            return false;
        }
        return false;
    }

    private boolean parseMultiCharOptionReturnTrueIfSkipNextArg(String arg, String nextArg) {
        boolean twoDashes = arg.startsWith("--");
        String option = arg.substring(twoDashes ? 2 : 1);
        int equalSign = option.indexOf(61, 1);
        String optionArg = null;
        boolean skipNextArg = false;
        if (equalSign > 0) {
            optionArg = option.substring(equalSign + 1);
            option = option.substring(0, equalSign);
        } else if (nextArg != null && this.optionsExpectingArguments.contains(option)) {
            optionArg = nextArg;
            skipNextArg = true;
        }
        this.options.add(option);
        if (optionArg != null) {
            this.putOptionArgument(option, optionArg);
        }
        return skipNextArg;
    }

    public boolean hasOption(String option) {
        if (!this.parsed) {
            throw new IllegalStateException();
        }
        return this.options.contains(option);
    }

    public List<String> getOptions() {
        if (!this.parsed) {
            throw new IllegalStateException();
        }
        return this.options;
    }

    public String getOptionArgument(String option) {
        if (!this.parsed) {
            throw new IllegalStateException();
        }
        List<String> args = this.optionArguments.get(option);
        if (args == null || args.isEmpty()) {
            return null;
        }
        return args.get(args.size() - 1);
    }

    public List<String> getOptionArguments(String option) {
        if (!this.parsed) {
            throw new IllegalStateException();
        }
        return this.optionArguments.get(option);
    }

    public Map<String, List<String>> getAllOptionArguments() {
        if (!this.parsed) {
            throw new IllegalStateException();
        }
        return this.optionArguments;
    }

    public List<String> getOperands() {
        if (!this.parsed) {
            throw new IllegalStateException();
        }
        return this.operands;
    }
}

